﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_07
{
    public class Main : Script
    {
/// /////////////////////////////////////////////CUSTOM/////////////////////////////////////////
        Keys IMKey = Keys.F4;  // Press this ket to immobilize the target (start stasis).
        Keys KillKey = Keys.F7;  // During stasis, Press this key to instantly kill the target.
/// ////////////////////////////////////////////////////////////////////////////////////////////////
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        bool IMKeyPressed = false;
        Entity IMEntity = null;
        Entity RayEntity = null;
        Vector3 IMPosition = new Vector3(0, 0, 0);

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }

        private void OnTick(object sender, EventArgs e)
        {
            if (IMKeyPressed)
            {
                    Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.00375, 0.0075, 190, 255, 190, 255); 
                    Function.Call(Hash.DRAW_RECT, 0.5, 0.5, 0.0025, 0.005, 0, 60, 0, 255);  
            }
            if (IMEntity != null)
            {
                     if (World.GetDistance(playerPed.Position, IMEntity.Position) > 200 || (Function.Call<bool>(Hash.IS_ENTITY_A_PED, IMEntity) && IMEntity.IsDead))
                     {
                              IMEntity = null;
                              IMPosition = new Vector3(0, 0, 0);
                              RDR2.UI.Screen.ShowSubtitle("Stasis Off");
                     }
                     else
                     {
                              Function.Call(Hash.DRAW_RECT, 0.95, 0.35, 0.00375, 0.15, 190, 255, 190, 255); 
                              Function.Call(Hash.DRAW_RECT, 0.95, 0.35, 0.0025, (0.00075 * World.GetDistance(playerPed.Position, IMEntity.Position)), 0, 60, 0, 255); 
                              IMEntity.ApplyForce((IMPosition - IMEntity.Position) * 10f);  
                     }
            }
        } 

        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == IMKey && !e.Shift)
            {
                     IMKeyPressed = true;
            }
        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == IMKey && !e.Shift)
            {
                     if (IMEntity != null)
                     {
                              Function.Call(Hash.SET_ENTITY_VELOCITY, IMEntity, 0, 0, 0);
                              IMEntity = null;
                              IMPosition = new Vector3(0, 0, 0);
                              RDR2.UI.Screen.ShowSubtitle("Stasis Off");
                     }
                     else
                     {
                             if (RayEntity == null)
                             {
                                      Model PlayerModel = new Model(Function.Call<int>(Hash.GET_ENTITY_MODEL, playerPed));
	                      Function.Call(Hash.REQUEST_MODEL, PlayerModel);
                                      while (!Function.Call<bool>(Hash.HAS_MODEL_LOADED, PlayerModel))
                                      {
                                               Wait(1);
                                      }
	                      RayEntity = Function.Call<Ped>(Hash.CREATE_PED, PlayerModel, 0, 0, 0, 1.0, false, false);
                                      Function.Call(Hash.SET_ENTITY_INVINCIBLE, RayEntity, true);
                             }
                             Vector3 RaySpace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Y * 100.0f, RotToDir(NC_Get_Cam_Rotation()).Z * 100.0f);
                             Vector3 TargetPosition = NC_Get_Cam_Position() + RaySpace;
                             Function.Call(Hash.SET_ENTITY_VISIBLE, RayEntity, false);
                             Function.Call(Hash.SET_ENTITY_HAS_GRAVITY, RayEntity, false);
                             Function.Call(Hash.SET_ENTITY_ROTATION, RayEntity, 0, 0, ((NC_Get_Cam_Rotation()).Z), 2, true); 
                             Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, TargetPosition.X, TargetPosition.Y, (TargetPosition.Z), true, false, false, false);
                             Wait(10);
                             RaycastResult Raycast = World.Raycast(NC_Get_Cam_Position(), RayEntity.Position, IntersectOptions.Everything, playerPed);
                             Wait(10);
                             if (Raycast.DitHitEntity) 
                             {
                                    if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, Raycast.HitEntity))
                                    {
                                               if (!Raycast.HitEntity.IsDead)
                                               {
                                                          IMEntity = Raycast.HitEntity;
                                                          IMPosition = Raycast.HitEntity.Position;
                                                          RDR2.UI.Screen.ShowSubtitle("Stasis On");
                                               }
                                               else
                                               {
                                                          RDR2.UI.Screen.ShowSubtitle("There is no need to immobilize a dead body.");
                                               }
                                    }
                                    else
                                    {
                                               if (Function.Call<bool>(Hash.IS_ENTITY_A_VEHICLE, Raycast.HitEntity))
                                               {
                                                          IMEntity = Raycast.HitEntity;
                                                          RDR2.UI.Screen.ShowSubtitle("Stasis On");
                                               }
                                               else
                                               {
                                                          RDR2.UI.Screen.ShowSubtitle("There is no need to immobilize this object.");
                                               }
                                    }
                             }
                             Wait(10);
                             Function.Call(Hash.SET_ENTITY_COORDS, RayEntity, 0, 0, 0, true, false, false, false);
                     }
            }
            if (e.KeyCode == KillKey && IMEntity != null)
            {
                     if (Function.Call<bool>(Hash.IS_ENTITY_A_PED, IMEntity))
                     {
                              int Damage =  Function.Call<int>(Hash.GET_ENTITY_MAX_HEALTH, IMEntity) + 1;
                              Function.Call(Hash.APPLY_DAMAGE_TO_PED, IMEntity, Damage, false);
                              if (IMEntity.IsDead)
                              {
                                      IMEntity = null;
                                      RDR2.UI.Screen.ShowSubtitle("Target is destroyed.");
                              }
                     }
                     else
                     {
                              Function.Call(Hash.ADD_EXPLOSION, (IMEntity.Position.X), (IMEntity.Position.Y), (IMEntity.Position.Z), 23, 0.5f, true, false, 0);
                              IMEntity = null;
                              RDR2.UI.Screen.ShowSubtitle("Target is destroyed.");
                     }
            }
            if (e.KeyCode == IMKey)
            {
                     IMKeyPressed = false;
            }
        }

        public Vector3 RotToDir(Vector3 Rot)
        {
            try
            {
                float z = Rot.Z;
                float retz = z * 0.0174532924F;
                float x = Rot.X;
                float retx = x * 0.0174532924F;
                float absx = (float)System.Math.Abs(System.Math.Cos(retx));
                return new Vector3((float)-System.Math.Sin(retz) * absx, (float)System.Math.Cos(retz) * absx, (float)System.Math.Sin(retx));
            }
            catch
            {
                return new Vector3(0, 0, 0);
            }
        }

        public Vector3 NC_Get_Cam_Position()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_COORD);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        }

        public Vector3 NC_Get_Cam_Rotation()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_ROT, 0);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        } 
    }
}
